*Note: This summary is AI-generated but has been validated by at least one of the attendants.*

### Key Discussion Points

*   **KDE Interest in AI/ML:** The KDE SIG is interested in leveraging Ollama and the AI/ML stack on x86_64, aarch64, and eventually RISC-V. A specific application mentioned is "Alpaka".
*   **State of Ollama:**
    *   Due to changes in golang packaging, Ollama's go dependencies are now bundled, which has simplified updates for Fedora and EPEL.
    *   aarch64 support has been enabled, with Alexander Lent as the maintainer.
    *   The only currently supported backend is ROCm, but there is an opportunity to add others like OpenCL and Vulkan.
    *   Help is needed from other SIGs (like Fedora RISC-V) to expand architecture support.
*   **Fedora 44 Readiness:**
    *   The branch date for Fedora 44 is 2026-02-03.
    *   Packages `onnx` and `onnxruntime` are currently failing to build and require attention.
    *   The Boost 1.90 update is causing build failures for `miopen` and other packages, and this is being actively worked on.
*   **ROCm Compatibility Proposal for F45:**
    *   A proposal was discussed to allow multiple major versions of ROCm to be installed simultaneously (e.g., the latest version and the previous major version).
    *   The goal is to reduce friction for packages that depend on ROCm, allowing them to update at their own pace rather than being forced to move immediately with every new ROCm release.
*   **EPEL 10 Issues:**
    *   `python3-torch` and `magma` are currently broken in EPEL 10.2 after the ROCm 7 rebase.
    *   A concern was raised that major updates like the ROCm rebase should not be pushed to stable if they break dependencies, as this violates EPEL's repoclosure policy. It was agreed that this would be the policy going forward.
*   **Future Packaging:**
    *   There is interest in updating the `ollama` package more frequently.
    *   There is interest in packaging `open-webui`, but it is currently difficult due to its dependency on older Python versions that are not available in Rawhide.

### Action Items

*   **Tom Rix:** Add an `%ollama_arches` macro to the Ollama package to better manage architecture support for dependent packages.
*   **Tom Rix:** Investigate the `python3-torch` build failure in EPEL 10.2.
*   **Tom Rix:** Fix the `magma` package in EPEL 10.2 as part of the ROCm 7.1.1 update.
*   **Steve Cossette (Farchord):** Will look into helping with more frequent updates to the `ollama` package, starting after the F44 branch in February.
*   **AI/ML SIG:** Consider creating an `ollama-next` COPR to facilitate faster development and testing of Ollama updates.